function maxproj(foldername)
%make max z-projections of single-plane z-stack t-files in folders
%generated by Volocity. 

seqfolders=dir([foldername,'*']); %sequencing folder names
mkdir(['maxproj',foldername]);
for k=1:length(seqfolders)
    olddir=cd(seqfolders(k).name);
    files=dir('*.tif');
    tcz=zeros(length(files),3);
    prefixend=regexp(files(1).name,'T[01234567890]+C[01234567890]+Z');
    
    for i=1:length(files)
        tcz(i,:)=cell2mat(textscan(files(i).name(prefixend:end),'T%uC%uZ%u'));
    end
    
    im=cell(1,1,length(files));
    for i=1:length(files)
        im{i}=imread(files(i).name);
    end
    im=cell2mat(im);
    immax=zeros(size(im,1),size(im,2),4);
    for i=1:max(tcz(:,2))
        immax(:,:,i)=max(im(:,:,tcz(:,2)==i),[],3);
    end
    immax=uint16(immax);
    
    
    cd(['../','maxproj',foldername]);
    imwrite(immax(:,:,1),['maxproj',seqfolders(k).name,'.tif']);
    for i=2:max(tcz(:,2))
        imwrite(immax(:,:,i),['maxproj',seqfolders(k).name,'.tif'],'WriteMode','Append');
    end
    cd(olddir);
end